#include <stdio.h>
#include "IIC_L.h"
#include "delay.h"
#include "usart.h"
#include "GXTR304.H"

#define GXTR304_ADDR 0X90

unsigned char GXTR304_LOCK(unsigned char LOCK_EN) // :0X00 0x01
{
    unsigned char CODE_ERR = 0x00;
    unsigned char MSB = 0X00, LSB = 0X00;
    unsigned short LOCK_VAL = 0X0000;
    switch (LOCK_EN)
    {
    case (0x00):
        W_2BYTE_IIC_L(GXTR304_ADDR, 0XC4, 0XEB, 0X19);
        delay_ms(10);
        R_2BYTE_IIC_L(GXTR304_ADDR, 0XC4, &MSB, &LSB);
        LOCK_VAL = MSB << 8 | LSB;
        if (LOCK_VAL != 0x0000)
            CODE_ERR = 0x01; // unlock ERR
        break;
    case (0x01):
        W_2BYTE_IIC_L(GXTR304_ADDR, 0XC4, 0X5C, 0XA6);
        delay_ms(10);
        R_2BYTE_IIC_L(GXTR304_ADDR, 0XC4, &MSB, &LSB);
        LOCK_VAL = MSB << 8 | LSB;
        if (LOCK_VAL != 0x8000)
            CODE_ERR = 0x02; // lock ERR
        break;
    default:
        CODE_ERR = 0x03; // code ERR
    }
    return CODE_ERR;
}

void GXTR304_Read_Temp(unsigned char channel) // channel:0x00-0x04 0x00:¶ 0x01-0x04Զ1Զ4¶
{
    unsigned char MSB = 0X00, LSB = 0X00;
    unsigned short REG_VALUE = 0X0000;
    float Temp = 0.0;
    R_2BYTE_IIC_L(GXTR304_ADDR, channel, &MSB, &LSB);
    REG_VALUE = MSB << 8 | LSB;
    if (MSB & 0X80) // ¶
    {
        REG_VALUE = ~REG_VALUE;
        REG_VALUE += 0X0001;
        Temp = REG_VALUE * 0.0078125;
        printf("GXTR304_TEMP:-%03.6f\r\n", Temp);
    }
    else
    {
        Temp = REG_VALUE * 0.0078125;
        printf("GXTR304_TEMP:%03.6f\r\n", Temp);
    }
}
unsigned char GXTR304_Shutdown(void)
{
    unsigned char CODE_ERR = 0x00;
    unsigned char MSB = 0X00, LSB = 0X00;
    W_2BYTE_IIC_L(GXTR304_ADDR, 0X30, 0XFF, 0XBC); // SDλ1
    delay_ms(10);
    R_2BYTE_IIC_L(GXTR304_ADDR, 0X30, &MSB, &LSB);
    if (((MSB << 8 | LSB) & 0XFFBC) != 0XFFBC)
        CODE_ERR = 0x05; // SD ERR
    return CODE_ERR;
}
