
#ifndef __ONEWIRE_HEADER_FILE
#define __ONEWIRE_HEADER_FILE

// library reference
#include "stdio.h"
#include "stdint.h"
#include "stm32f10x_gpio.h"
#include "stm32f10x_rcc.h"


#define ONEWIRE_CLK  RCC_APB2Periph_GPIOB 
#define ONEWIRE_PORT GPIOB
#define ONEWIRE_PIN  GPIO_Pin_7


// function declaration
void    gxt110_onewire_init       (void);
void    gxt110_onewire_pulldown   (void);
void    gxt110_onewire_release    (void);
uint8_t gxt110_onewire_receive    (void);
void    gxt110_onewire_reset      (void);
void    gxt110_onewire_activate   (void);
uint8_t gxt110_onewire_read_bit   (void);
void    gxt110_onewire_write_bit  (uint8_t txd);
void    gxt110_onewire_write_token(uint8_t txd);

#endif
