
#include "gxt110.h"
#include "onewire110.h"
#include "delay.h"





uint8_t  SENSOR_NUM = 0;
uint8_t  SENSOR_ADDR[SENSOR_NUM_MAX]={0};  
uint16_t SENSOR_TEMP[SENSOR_NUM_MAX]={0};



/*---------------------------------------------------------------------
  Function    : gxt110_read_temp             
  Description : convert and read the temperature
  Parameter   : none
  Return      : received temperature
---------------------------------------------------------------------*/
void gxt110_read_temp(void)    //º
{
  uint32_t dat = 0;
  uint8_t i;
  gxt110_onewire_activate();
  delay_ms(200);
  
  // BUSY[1:0] -> TEMP[15:0]
  
  for(i = 0; i < 18; i ++) {
    dat = dat << 1;
    dat = dat | ((gxt110_onewire_read_bit() == 0) ? 0x0000000000000000 : 0x0000000000000001);
  }
  
  dat=(dat&0X0000FFFF);
  
  if(dat&0x8000) 
  {
     dat=~(dat-1);
     printf("\r\ntemp=%f\r\n",-dat*0.0078125);
  }
  else printf("\r\ntemp=%f\r\n",dat*0.0078125);
}




/*---------------------------------------------------------------------
  Function    : gxt110_reset            
  Description : reset and assign addresses
  Parameter   : none
  Return      : received address
---------------------------------------------------------------------*/
//uint8_t gxt110_reset(void)
//{
//  uint8_t dat = 0;
//	uint8_t i;
//  gxt110_onewire_reset();
//  
//  // ACK -> ADR[3:0]
//  
//  for(i = 0; i < 5; i ++) {
//    dat = dat << 1;
//    dat = dat | ((gxt110_onewire_read_bit() == 0) ? 0x00 : 0x01);
//  }
//  
//  return dat;
//}





/*---------------------------------------------------------------------
  Function    : gxt110_assign_addr             
  Description : assign_addr
  Parameter   : none
  Return      : none
---------------------------------------------------------------------*/
//void gxt110_assign_addr()
//{
//	uint8_t i;
//	uint8_t addr=0;
//	SENSOR_NUM = 0;
//  gxt110_onewire_reset();
//	while(1)
//	{
//		addr=0;
//		if(gxt110_onewire_read_bit())                   //no ack
//		{
//			printf("\r\n search complete\r\n");
//			printf("\r\n %d GXt110 on the bus\r\n",SENSOR_NUM);
//			for(i=0;i<SENSOR_NUM;i++)
//			{
//			   printf("\r\n num%d address is %X\r\n",i,SENSOR_ADDR[i]);
//			}			
//			return;
//		}
//		else 
//		{
//			SENSOR_NUM++;
//			for(i=0;i<4;i++)
//			{
//        addr = addr << 1;
//        addr = addr | ((gxt110_onewire_read_bit() == 0) ? 0x00 : 0x01);			  
//			}
//			SENSOR_ADDR[SENSOR_NUM-1] = addr;		
//		}		
//	}
//}




/*---------------------------------------------------------------------
  Function    : gxt110_convert             
  Description : convert and read multiple temperature
  Parameter   : none
  Return      : received temperature
---------------------------------------------------------------------*/
//void gxt110_read_mul_temp(void) 
//{
//  uint32_t dat = 0;
//	uint16_t temp = 0;
//  uint8_t i,num;
//  gxt110_onewire_activate();
//  delay_ms(200);
//  
//  // BUSY[1:0] -> TEMP[15:0]
//	gxt110_onewire_read_bit();    //BUSY[1]
//	gxt110_onewire_read_bit();    //BUSY[0]
//  for(num = 0; num < SENSOR_NUM; num++)
//	{
//		for(i = 0; i < 17; i ++) 
//		{
//			dat = dat << 1;
//			dat = dat | ((gxt110_onewire_read_bit() == 0) ? 0x0000000000000000 : 0x0000000000000001);
//		}
//		temp = (dat&0X0001FFFF)>>1 ;
//		SENSOR_TEMP[num] = temp;		
////		printf("\r\n%#x\r\n",temp);
//	}
//	
//}




