#include "GXHT4x.h"
#include "delay.h"

#define write 0
#define read  1

/*
* @name   CRC_8
* @brief  CRC-8У
* @param  Crc_ptr -> У׵ַ
		LEN     -> Уݳ
* @retval CRC_Value -> Уֵ      
*/
static uint8_t CRC_8(uint8_t *Crc_ptr,uint8_t LEN)
{
	uint8_t CRC_Value = 0xFF;
	uint8_t i = 0,j = 0;

	for(i=0;i<LEN;i++)
	{
		CRC_Value ^= *(Crc_ptr+i);
		for(j=0;j<8;j++)
		{
			if(CRC_Value & 0x80)
				CRC_Value = (CRC_Value << 1) ^ 0x31;
			else
				CRC_Value = (CRC_Value << 1);
		}
	}
	return CRC_Value;
}


/****************************************************************************
* Function Name  : GXHT4X_GPIO_INIT
* Description    : ʼGPIO.
* Input          : None
* Output         : None
* Return         : None
****************************************************************************/
void GXHT4X_GPIO_INIT(void)
{	
	
	GPIO_InitTypeDef GPIO_InitStructure;	
			
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA,ENABLE);
	GPIO_InitStructure.GPIO_Pin=GXHT4X_SDA;
	GPIO_InitStructure.GPIO_Speed=GPIO_Speed_10MHz;
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_OD;
	GPIO_Init(GPIO_GXHT4X,&GPIO_InitStructure);
	
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA,ENABLE);
	GPIO_InitStructure.GPIO_Pin=GXHT4X_SCL;
	GPIO_InitStructure.GPIO_Speed=GPIO_Speed_10MHz;
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_OD;
	GPIO_Init(GPIO_GXHT4X,&GPIO_InitStructure);
	
	GXHT4X_SCL_H;
	GXHT4X_SDA_H;
	delay_ms(100);									//ȴϵͳԴȶ
	
	GXHT4XReset(GXHT4X_ADDRESS);	//λ ȷоƬѾ
}

/*******************************************************************************
*            : GXHT4X_SDA_OUT
* 		     : SDA	   
*              : 
*              : 
*******************************************************************************/
void GXHT4X_SDA_OUT(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;	
	
	GPIO_InitStructure.GPIO_Pin=GXHT4X_SDA;
	GPIO_InitStructure.GPIO_Speed=GPIO_Speed_10MHz;
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_OD;
	GPIO_Init(GPIO_GXHT4X,&GPIO_InitStructure);
}

/*******************************************************************************
*            : GXHT4X_SDA_IN
* 		   	 : SDA	   
*              : 
*              : 
*******************************************************************************/
void GXHT4X_SDA_IN(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;	
	
	GPIO_InitStructure.GPIO_Pin=GXHT4X_SDA;
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_AF_OD;
	GPIO_Init(GPIO_GXHT4X,&GPIO_InitStructure);
}

void GXHT4X_SDA_in(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;	
	
	GPIO_InitStructure.GPIO_Pin=GXHT4X_SDA;
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_IPU;
	GPIO_Init(GPIO_GXHT4X,&GPIO_InitStructure);
}


//ʼź
void GXHT4X_StarT(void)
{
  GXHT4X_SDA_OUT();
	
	GXHT4X_SDA_H;
	GXHT4X_SCL_H;
	delay_us(5);
	GXHT4X_SDA_L;
	delay_us(6);
	GXHT4X_SCL_L;
}

//ֹͣź
void GXHT4X_StoP(void)
{
   GXHT4X_SDA_OUT();

   GXHT4X_SCL_L;
   GXHT4X_SDA_L;
   GXHT4X_SCL_H;
   delay_us(6);
   GXHT4X_SDA_H;
   delay_us(6);
}

//ӦźACK
void GXHT4X_Ack(void)
{
   GXHT4X_SCL_L;
   GXHT4X_SDA_OUT();
   GXHT4X_SDA_L;
   delay_us(2);
   GXHT4X_SCL_H;
   delay_us(5);
   GXHT4X_SCL_L;
}

//ӦźNACK
void GXHT4X_NAck(void)
{
   GXHT4X_SCL_L;
   GXHT4X_SDA_OUT();
   GXHT4X_SDA_H;
   delay_us(2);
   GXHT4X_SCL_H;
   delay_us(5);
   GXHT4X_SCL_L;
}
//ȴӻӦź
//ֵ1 Ӧʧ
//		  	0 Ӧɹ
u8 GXHT4X_Wait_Ack(void)
{
	u8 tempTime=0;
	GXHT4X_SDA_IN();
	GXHT4X_SDA_H;
	delay_us(1);
	GXHT4X_SCL_H;
	delay_us(1);

	while(GPIO_ReadInputDataBit(GPIO_GXHT4X,GXHT4X_SDA))
	{
		tempTime++;
		delay_us(1);
		if(tempTime>250)
		{
			GXHT4X_StoP();
			return 1;
		}	 
	}
	GXHT4X_SCL_L;
	delay_us(1);
	return 0;
}
//GXHT4X һֽ
void GXHT4X_Send_Byte(u8 txd)
{
	u8 i=0;
	GXHT4X_SDA_OUT();
	GXHT4X_SCL_L;//ʱӿʼݴ

	for(i=0;i<8;i++)
	{
		if((txd&0x80)>0) //0x80  1000 0000
			GXHT4X_SDA_H;
		else
			GXHT4X_SDA_L;

		txd<<=1;
		delay_us(1);
		GXHT4X_SCL_H;
		delay_us(2); //
		GXHT4X_SCL_L;
		delay_us(2);
	}
}

//GXHT4X ȡһֽ

u8 GXHT4X_Read_Byte(u8 ack)
{
   u8 i=0,receive=0;

   GXHT4X_SDA_in();
   for(i=0;i<8;i++)
   {
   		GXHT4X_SCL_L;
		delay_us(2);
		GXHT4X_SCL_H;
		while(!GPIO_ReadInputDataBit(GPIO_GXHT4X,GXHT4X_SCL));
		receive<<=1;
		if(GPIO_ReadInputDataBit(GPIO_GXHT4X,GXHT4X_SDA))
		   receive++;
		delay_us(1);	
   }

   	if(ack==0)
	   	GXHT4X_NAck();
	else
		GXHT4X_Ack();

	return receive;
}

void GXHT4X_read_result(u8 GXHT4x_ADDRESS, float *GXHT4x_TEMP,float *GXHT4x_HUMI)
{
	u16 tem,hum;
	unsigned char buff[6];
	float temperature,humidity;
	
	GXHT4X_StarT();
	GXHT4X_Send_Byte(GXHT4x_ADDRESS <<1 | write);//д7λGXHT4X豸ַ0Ϊдȡλ,1Ϊȡλ
	GXHT4X_Wait_Ack();
	GXHT4X_Send_Byte(GXHT4X_CMD_MEASURE_HPM);
	GXHT4X_Wait_Ack();
	GXHT4X_StoP();
	
	delay_ms(10);																//ȴоƬת
	
	GXHT4X_StarT();
	GXHT4X_Send_Byte(GXHT4x_ADDRESS <<1 | read);//д7λGXHT4X豸ַ0Ϊдȡλ,1Ϊȡλ
	
	if(GXHT4X_Wait_Ack()==0)
	{
		GXHT4X_SDA_in();		
		buff[0]=GXHT4X_Read_Byte(1);
		buff[1]=GXHT4X_Read_Byte(1);
		buff[2]=GXHT4X_Read_Byte(1);
		buff[3]=GXHT4X_Read_Byte(1);
		buff[4]=GXHT4X_Read_Byte(1);
		buff[5]=GXHT4X_Read_Byte(0);
		GXHT4X_StoP();
			
		if(CRC_8(buff, 2) == buff[2] && CRC_8(buff + 3, 2) == buff[5])
		{
			tem = ((buff[0]<<8) | buff[1]);//¶ƴ
			hum = ((buff[3]<<8) | buff[4]);//ʪƴ
		
			temperature = 175.0 * (float)tem / 65535.0 - 45.0 ;	// T = -45 + 175 * tem / (2^16)
			humidity = 125.0 * (float)hum / 65535.0 - 6;			// RH = -6 + 125 * hum / (2^16)
		
			if(humidity >= 100)
				humidity = 100;
				
			if((temperature>=-45&&temperature<=125)&&(humidity>=0 && humidity<=100))//˴
			{
				*GXHT4x_TEMP = temperature;
				*GXHT4x_HUMI = humidity;		
			}
			
		}
		else
		{
			*GXHT4x_TEMP = 0;
			*GXHT4x_HUMI = 0;
		}
	}
	
	tem = 0;
	hum = 0;
	
}


/****************************************************************************
* Function Name  : GXHT4XReset
* Description    : GXHT4Xλ
* Input          : None
* Output         : None
* Return         : None
****************************************************************************/
void GXHT4XReset(u8 GXHT4x_ADDRESS)
{
	GXHT4X_StarT();
	GXHT4X_Send_Byte(GXHT4x_ADDRESS << 1 |  write);
	GXHT4X_Wait_Ack();
	GXHT4X_Send_Byte(GXHT4X_CMD_RESET);
	GXHT4X_Wait_Ack();
	GXHT4X_StoP();
	delay_ms(1);
}

