#include "gxA574.h"
#include "delay.h"
#include "usart.h"
#include "string.h"

 
 
//ʼIIC
void IIC_Init(void)
{					     
	GPIO_InitTypeDef GPIO_InitStructure;
	RCC_APB2PeriphClockCmd(	RCC_APB2Periph_GPIOB, ENABLE );	//ʹGPIOBʱ
	   
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_6|GPIO_Pin_7;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_OD ;   //
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(GPIOB, &GPIO_InitStructure);
	
	GPIO_SetBits(GPIOB,GPIO_Pin_6|GPIO_Pin_7); 	//PB6,PB7 
	
}
//IICʼź
void IIC_Start(void)
{
	SDA_OUT();//sda
	IIC_SDA=1;	  	  
	IIC_SCL=1;
	delay_us(2);
 	IIC_SDA=0;//START:when CLK is high,DATA change form high to low 
	delay_us(2);
	IIC_SCL=0;//ǯסI2Cߣ׼ͻ 
}	  
//IICֹͣź
void IIC_Stop(void)
{
	SDA_OUT();//sda
	IIC_SCL=0;
	IIC_SDA=0;//STOP:when CLK is high DATA change form low to high
 	delay_us(2);
	IIC_SCL=1; 
	delay_us(2);
	IIC_SDA=1;//I2C߽ź
	delay_us(2);							   	
}
//ȴӦźŵ
//ֵ1Ӧʧ
//        0Ӧɹ

/*ȴӦȰsdasclߣ
  һֱΪ ˵ܵǷӦźţNACKߴʧܣ
  sdaΪ͵ƽյӦźţ
*/
u8 IIC_Wait_Ack(void)
{
	u8 ucErrTime=0;
	SDA_IN();      //SDAΪ  
	IIC_SDA=1;delay_us(1);	   
	IIC_SCL=1;delay_us(1);	
	
	while(READ_SDA)
	{
		ucErrTime++;
		if(ucErrTime>250)
		{
			IIC_Stop();
			return 1;
		}
	}
	
	IIC_SCL=0;//ʱ0 	   
	return 0;  
} 


u8 IIC_Wait_AckHT(void)
{
	u8 ucErrTime=0;
	SDA_IN();      //SDAΪ  
	IIC_SDA=1;delay_us(1);	   
	IIC_SCL=1;delay_us(1);	
	

	
	IIC_SCL=1;//ʱ0 	   
	
	return 0;  
} 









//ACKӦ
void IIC_Ack(void)
{
	IIC_SCL=0;
	SDA_OUT();
	IIC_SDA=0;
	delay_us(2);
	IIC_SCL=1;
	delay_us(2);
	IIC_SCL=0;
}
//ACKӦ		    
void IIC_NAck(void)
{
	IIC_SCL=0;
	SDA_OUT();
	IIC_SDA=1;
	delay_us(2);
	IIC_SCL=1;
	delay_us(2);
	IIC_SCL=0;
}					 				     
//IICһֽ
//شӻӦ
//1Ӧ
//0Ӧ			  
void IIC_Send_Byte(u8 txd)
{                        
    u8 t;   
	SDA_OUT(); 	    
    IIC_SCL=0;//ʱӿʼݴ
    for(t=0;t<8;t++)
    {              
        //IIC_SDA=(txd&0x80)>>7;
		if((txd&0x80)>>7)
			IIC_SDA=1;
		else
			IIC_SDA=0;
		txd<<=1; 	  
		delay_us(2);   //TEA5767ʱǱ
		IIC_SCL=1;
		delay_us(2); 
		IIC_SCL=0;	
		delay_us(2);
    }	 
} 	    
//1ֽڣack=1ʱACKack=0nACK   
u8 IIC_Read_Byte(unsigned char ack)
{
	unsigned char i,receive=0;
	SDA_IN();//SDAΪ
    for(i=0;i<8;i++ )
	  {
        IIC_SCL=0; 
        delay_us(2);
	    	IIC_SCL=1;
        receive<<=1;//Ӧλڳλ
        if(READ_SDA)receive++;   
		    delay_us(1); 
    }					 
    if (!ack)
        IIC_NAck();//nACK
    else
        IIC_Ack(); //ACK   
    return receive;
}


/*--------------------------------Ӧò-------------------------------------------*/



void  Gx8574_Read_All()
{
		u8 df;

		IIC_Start();
		IIC_Send_Byte(0x41);// ---ַ
		IIC_Wait_Ack();//ȴӻACK
	 
		df=IIC_Read_Byte(0);
		 
		IIC_Stop();	
	
		UartOutB(df);//ǰIOƽ״̬	
	
}


void  Gx8574_Output_Pin(u8 dat)
{
		u8 df;

		IIC_Start();
		IIC_Send_Byte(0x40);// ---ַ
		IIC_Wait_Ack();
	 
		IIC_Send_Byte(dat);// ---ַ
		IIC_Wait_Ack();
	 
	
		IIC_Stop();	
	
}



void  Gx8574_Output_PinIOHT()
{
		u8 df;

		IIC_Start();
		IIC_Send_Byte(0x40);// ---ַ
		IIC_Wait_Ack();

		IIC_Send_Byte(0X00);// ---ַ
		IIC_Wait_Ack();


		IIC_Stop();	



		IIC_Start();
		IIC_Send_Byte(0x40);// ---ַ
		IIC_Wait_Ack();

		IIC_Send_Byte(0x20);// ---ַ

		IIC_Wait_AckHT();//SCLʱ߳ߣP5˿һֱǿ״̬
	

}

























