/**
  ******************************************************************************
  * @file    bsp_GX30H05.c
  * @brief   GX30H05¶ȴӦúӿ
  ******************************************************************************
 
  ******************************************************************************
  */

#include "./GX30H05/bsp_GX30H05.h"
#include "./systick/bsp_SysTick.h"
#include "./dwt_delay/core_delay.h"
#include "stdio.h"
/* ĺ궨аѺʱ滻SysTickʱǸͻǸ */

#define GX30H05_DELAY_US(us)  CPU_TS_Tmr_Delay_US(us)
#define GX30H05_DELAY_MS(ms)  CPU_TS_Tmr_Delay_MS(ms)

/**
  ******************************************************************************
  GX30H05ֻ18b20Ͻֱ޸Ϊ0.125
  18b20Ļ޸
  ******************************************************************************
  */

uint8_t  ucGX30H05Id [MaxSensorNum][ 8 ];// ⵽ĴGX30H05_ID,ǰάߴ
uint8_t GX30H05_SensorNum; // ⵽Ĵ(1ʼʾ1188)

static void                           GX30H05_GPIO_Config                       ( void );
static void                           GX30H05_Mode_IPU                          ( void );
static void                           GX30H05_Mode_Out_PP                       ( void );
static void GX30H05_Rst(void);
static uint8_t                        GX30H05_Presence                          ( void );
static uint8_t                        GX30H05_ReadBit                           ( void );
static uint8_t                        GX30H05_ReadByte                          ( void );
static void                           GX30H05_WriteByte                         ( uint8_t dat );
static void                           GX30H05_SkipRom                           ( void );
static void                           GX30H05_MatchRom                          ( void );



 /**
  * @brief  GX30H05 ʼ
  * @param  
  * @retval 
  */
uint8_t GX30H05_Init(void)
{
	GX30H05_GPIO_Config ();
	
	GX30H05_DQ_1;
	
	GX30H05_Rst();
	
	return GX30H05_Presence ();
	
}


/*
 * GX30H05_GPIO_Config
 *   GX30H05õI/O
 *   
 *   
 */
static void GX30H05_GPIO_Config(void)
{		
	/*һGPIO_InitTypeDef͵Ľṹ*/
	GPIO_InitTypeDef GPIO_InitStructure;
	

	/*DS18B20_DQ_GPIO_PORTʱ*/
	GX30H05_DQ_SCK_APBxClock_FUN ( GX30H05_DQ_GPIO_CLK, ENABLE); 

	/*ѡҪƵDS18B20_DQ_GPIO_PORT*/															   
  	GPIO_InitStructure.GPIO_Pin = GX30H05_DQ_GPIO_PIN;	

	/*ģʽΪͨ*/
  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;   

	/*Ϊ50MHz */   
  	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz; 

	/*ÿ⺯ʼDS18B20_DQ_GPIO_PORT*/
  	GPIO_Init ( GX30H05_DQ_GPIO_PORT , &GPIO_InitStructure );

}

/*
 * GX30H05_Mode_IPU
 *   ʹGX30H05-DATAűΪģʽ
 *   
 *   
 */
static void GX30H05_Mode_IPU(void)
{
 	  GPIO_InitTypeDef GPIO_InitStructure;

	  	/*ѡҪƵGX30H05_DQ_GPIO_PORT*/	
	  GPIO_InitStructure.GPIO_Pin = GX30H05_DQ_GPIO_PIN;

	   /*ģʽΪģʽ*/ 
	  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;	

	  /*ÿ⺯ʼGX30H05_DQ_GPIO_PORT*/
	  GPIO_Init(GX30H05_DQ_GPIO_PORT, &GPIO_InitStructure);
}


/*
 * GX30H05_Mode_Out_PP
 *   ʹDS18B20-DATAűΪģʽ
 *   
 *   
 */
static void GX30H05_Mode_Out_PP(void)
{
 	GPIO_InitTypeDef GPIO_InitStructure;

	 	/*ѡҪƵGX30H05_DQ_GPIO_PORT*/															   
  	GPIO_InitStructure.GPIO_Pin = GX30H05_DQ_GPIO_PIN;	

	/*ģʽΪͨ*/
  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;   

	/*Ϊ50MHz */   
  	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;

	/*ÿ⺯ʼDS18B20_DQ_GPIO_PORT*/
  	GPIO_Init(GX30H05_DQ_GPIO_PORT, &GPIO_InitStructure);
}


/*
 *ӻ͸λ
 */
 static void GX30H05_Rst(void)
{
	/* Ϊ */
	GX30H05_Mode_Out_PP();
	
	GX30H05_DQ_0;
	/* ٲ480usĵ͵ƽλź */
	GX30H05_DELAY_US(750);
	
	/* ڲλźź轫 */
	GX30H05_DQ_1;
	
	/*ӻյĸλźź󣬻15~60usһ*/
	GX30H05_DELAY_US(30);
}


/*
 * ӻصĴ
 * 0ɹ
 * 1ʧ
 */
static uint8_t GX30H05_Presence(void)
{
	uint8_t pulse_time = 0;
	
	/* Ϊ */
	GX30H05_Mode_IPU();
	
	/* ȴĵΪһ60~240usĵ͵ƽź 
	 * ûʱӻյĸλźź󣬻15~60usһ
	 */
	while( GX30H05_DQ_IN() && pulse_time<100 )
	{
		pulse_time++;
		GX30H05_DELAY_US(1);
	}	
	/* 100us󣬴嶼ûе*/
	if( pulse_time >=100 )
		return 1;
	else
		pulse_time = 0;
	
	/* 嵽Ҵڵʱ䲻ܳ240us */
	while( !GX30H05_DQ_IN() && pulse_time<240 )
	{
		pulse_time++;
		GX30H05_DELAY_US(1);
	}	
	if( pulse_time >=240 )
		return 1;
	else
		return 0;
}


/*
 * GX30H05ȡһbit
 */
static uint8_t GX30H05_ReadBit(void)
{
	uint8_t dat;
	
	/* 0Ͷ1ʱҪ60us */	
	GX30H05_Mode_Out_PP();
	/* ʱʼ >1us <15us ĵ͵ƽź */
	GX30H05_DQ_0;
	GX30H05_DELAY_US(10);
	
	/* ó룬ͷߣⲿ轫 */
	GX30H05_Mode_IPU();
	//DS18B20_DELAY_US(2);
	
	if( GX30H05_DQ_IN() == SET )
		dat = 1;
	else
		dat = 0;
	
	/* ʱοʱͼ */
	GX30H05_DELAY_US(45);
	
	return dat;
}


/*
 * GX30H05һֽڣλ
 */
static uint8_t GX30H05_ReadByte(void)
{
	uint8_t i, j, dat = 0;	
	
	for(i=0; i<8; i++) 
	{
		j = GX30H05_ReadBit();		
		dat = (dat) | (j<<i);
	}
	
	return dat;
}


/*
 * дһֽڵGX30H05λ
 */
static void GX30H05_WriteByte(uint8_t dat)
{
	uint8_t i, testb;
	GX30H05_Mode_Out_PP();
	
	for( i=0; i<8; i++ )
	{
		testb = dat&0x01;
		dat = dat>>1;		
		/* д0д1ʱҪ60us */
		if (testb)
		{			
			GX30H05_DQ_0;
			/* 1us < ʱ < 15us */
			GX30H05_DELAY_US(8);
			
			GX30H05_DQ_1;
			GX30H05_DELAY_US(58);
		}		
		else
		{			
			GX30H05_DQ_0;
			/* 60us < Tx 0 < 120us */
			GX30H05_DELAY_US(70);
			
			GX30H05_DQ_1;			
			/* 1us < Trec(ָʱ) < */
			GX30H05_DELAY_US(2);
		}
	}
}


 /**
  * @brief  ƥ GX30H05 ROM
  * @param  
  * @retval 
  */
static void GX30H05_SkipRom ( void )
{
	GX30H05_Rst();	   
	
	GX30H05_Presence();	 
	
	GX30H05_WriteByte(0XCC);		/*  ROM */
	
}


 /**
  * @brief  ִƥ GX30H05 ROM
  * @param  
  * @retval 
  */
static void GX30H05_MatchRom ( void )
{
	GX30H05_Rst();	   
	
	GX30H05_Presence();	 
	
	GX30H05_WriteByte(0X55);		/* ƥ ROM */
	
}


/*
 * 洢¶16 λĴչĶƲʽ
 * 12λֱʱ5λ7λ4Сλ
 *
 *         |-------------------|-----С ֱ 1/(2^4)=0.0625----|
 * ֽ  | 2^3 | 2^2 | 2^1 | 2^0 | 2^(-1) | 2^(-2) | 2^(-3) | 2^(-4) |
 *
 *
 *         |-----λ0->  1->-------|----------------------|
 * ֽ  |  s  |  s  |  s  |  s  |    s   |   2^6  |   2^5  |   2^4  |
 *
 * 
 * ¶ = λ +  + С*0.0625
 */
 /**
  * @brief  ƥ ROM »ȡ GX30H05 ¶ֵ 
  * @param  
  * @retval ¶ֵ
  */
float GX30H05_GetTemp_SkipRom ( void )
{
	uint8_t tpmsb, tplsb;
	short s_tem;
	float f_tem;
	
	
	GX30H05_SkipRom ();
	GX30H05_WriteByte(0X44);				/* ʼת */
	GX30H05_DELAY_MS(800);
	
	GX30H05_SkipRom ();
  GX30H05_WriteByte(0XBE);				/* ¶ֵ */
	
	tplsb = GX30H05_ReadByte();		 
	tpmsb = GX30H05_ReadByte(); 
	
	
	s_tem = tpmsb<<8;
	s_tem = s_tem | tplsb;
	
	if( s_tem < 0 )		/* ¶ */
		f_tem = (~s_tem+1) * 0.125;	
	else
		f_tem = s_tem * 0.125;
	
	return f_tem; 	
	
	
}


 /**
  * @brief  ƥ ROM »ȡ GX30H05 ¶ֵ 
  * @param  GX30H05_idڴ GX30H05 кŵ׵ַ
  * @retval 
  */
void GX30H05_ReadId ( uint8_t * GX30H05_id )
{
	uint8_t uc;
	
	
	GX30H05_WriteByte(0x33);       //ȡк
	
	for ( uc = 0; uc < 8; uc ++ )
	  GX30H05_id [ uc ] = GX30H05_ReadByte();
	
}


 /**
  * @brief  ƥ ROM »ȡ GX30H05 ¶ֵ 
  * @param  GX30H05_id GX30H05 кŵ׵ַ
  * @retval ¶ֵ
  */
float GX30H05_GetTemp_MatchRom ( uint8_t * GX30H05_id )
{
	uint16_t tpmsb, tplsb, i;
	short s_tem;
	float f_tem;
	
	
	GX30H05_MatchRom ();            //ƥROM
	
  for(i=0;i<8;i++)
	GX30H05_WriteByte ( GX30H05_id [ i ] );	
	
	GX30H05_WriteByte(0X44);				/* ʼת */
  GX30H05_DELAY_MS(800);
	
	GX30H05_MatchRom ();            //ƥROM
	
	for(i=0;i<8;i++)
		GX30H05_WriteByte ( GX30H05_id [ i ] );	
	
	GX30H05_WriteByte(0XBE);				/* ¶ֵ */
	
	
  tplsb    =	GX30H05_ReadByte();	
  tpmsb    =	GX30H05_ReadByte();		 
	
	
	
	s_tem = tpmsb<<8;
	s_tem = s_tem | tplsb;
	
	
	if( s_tem < 0 )		/* ¶ */
		f_tem = (~s_tem+1) * 0.125;	
	else
		f_tem = s_tem * 0.125;

	return f_tem; 		
}



/*ΪѰ豸*/

// GX30H05ȡ1λ
uint8_t GX30H05_Read_Bit(void)
{
	uint8_t data;
	GX30H05_Mode_Out_PP();
	GX30H05_DQ_0; // ʱʼ >1us <15us ĵ͵ƽź
	GX30H05_DELAY_US(2);
	GX30H05_DQ_1;
	GX30H05_DELAY_US(12);
	GX30H05_Mode_IPU();// ó룬ͷߣⲿ轫
	if (GX30H05_DQ_IN())
		data = 1;
	else
		data = 0;
	GX30H05_DELAY_US(50);
	return data;
}
 
// GX30H05ȡ2λ
uint8_t GX30H05_Read_2Bit(void)//λ ӳ
{
	u8 i;
	u8 dat = 0;
	for (i = 2; i > 0; i--)
	{
		dat = dat << 1;
		GX30H05_Mode_Out_PP();
		GX30H05_DQ_0;
		GX30H05_DELAY_US(2);
		GX30H05_DQ_1;
		GX30H05_Mode_IPU();
		GX30H05_DELAY_US(12);
		if (GX30H05_DQ_IN())	dat |= 0x01;
		GX30H05_DELAY_US(50);
	}
	return dat;
}


// д1λGX30H05
void GX30H05_Write_Bit(uint8_t dat)
{
	GX30H05_Mode_Out_PP();
	if (dat)
	{
		GX30H05_DQ_0;// Write 1
		GX30H05_DELAY_US(2);
		GX30H05_DQ_1;
		GX30H05_DELAY_US(60);
	}
	else
	{
		GX30H05_DQ_0;// Write 0
		GX30H05_DELAY_US(60);
		GX30H05_DQ_1;
		GX30H05_DELAY_US(2);
	}
}




// ԶROM
void GX30H05_Search_Rom(void)
{
	uint8_t k, l, chongtuwei, m, n, num;
	uint8_t zhan[MaxSensorNum-1]={0};   //ֵҪȻֻҵһ
	uint8_t ss[64];
	uint8_t tempp;
	l = 0;
	num = 0;
	do
	{
		GX30H05_Rst(); //ע⣺λʱ
		GX30H05_DELAY_US(720); //480720
		GX30H05_WriteByte(0xf0);
		for (m = 0; m < 8; m++)
		{
			uint8_t s = 0;
			for (n = 0; n < 8; n++)
			{
				k = GX30H05_Read_2Bit();//λ
 
				k = k & 0x03;
				s >>= 1;
				if (k == 0x01)//01Ϊ0 д0 λΪ0Ӧ
				{
					GX30H05_Write_Bit(0);
					ss[(m * 8 + n)] = 0;
				}
				else if (k == 0x02)//Ϊ1 д1 λΪ1Ӧ
				{
					s = s | 0x80;
					GX30H05_Write_Bit(1);
					ss[(m * 8 + n)] = 1;
				}
				else if (k == 0x00)//Ϊ00 гͻλ жϳͻλ
				{
					//ͻλջд0 Сջдǰ ջд1
					chongtuwei = m * 8 + n + 1;
					if (chongtuwei > zhan[l])
					{
						GX30H05_Write_Bit(0);
						ss[(m * 8 + n)] = 0;
						zhan[++l] = chongtuwei;
					}
					else if (chongtuwei < zhan[l])
					{
						s = s | ((ss[(m * 8 + n)] & 0x01) << 7);
						GX30H05_Write_Bit(ss[(m * 8 + n)]);
					}
					else if (chongtuwei == zhan[l])
					{
						s = s | 0x80;
						GX30H05_Write_Bit(1);
						ss[(m * 8 + n)] = 1;
						l = l - 1;
					}
				}
				else
				{
					//û
				}
			}
			tempp = s;
			ucGX30H05Id[num][m] = tempp; // ID
		}
		num = num + 1;// ĸ
	} 
	while (zhan[l] != 0 && (num < MaxSensorNum));
	GX30H05_SensorNum = num;
	//printf("DS18B20_SensorNum=%d\r\n",DS18B20_SensorNum);
}




/*************************************END OF FILE******************************/
