/*--------------------------------------------------------------------------------------
  Copyright (c) 2021 GXCAS, Inc. All rights reserved

  File Name   : gx28e17.h
  Author      : GXCAS
  Date        : 2021-06-24
  Version     : 0.1
  Description : driver for GX28E17

  Modification History :
  Date      By       Version    Change Description
  ====================================================================================
  21/06/24  GXCAS  0.1        Original
--------------------------------------------------------------------------------------*/

#ifndef __GX28E17_HEADER_FILE
#define __GX28E17_HEADER_FILE

// library reference
#include "stdio.h"
#include "stdint.h"

// CRC-16 generator polynomial
#define CRC_POLY        0xA001

// I2C speed definition
#define SPD_SM          0x00
#define SPD_FM          0x01
#define SPD_PM          0x02

// max times of poll
#define POLL_MAX        50

// ROM command definition
#define ROM_READ        0x33
#define ROM_MATCH       0x55
#define ROM_SEARCH      0xF0
#define ROM_SKIP        0xCC
#define ROM_RESUME      0xA5
#define ROM_SKIP_OD     0x3C
#define ROM_MATCH_OD    0x69

// device command definition
#define DEV_WR_STP      0x4B
#define DEV_WR          0x5A
#define DEV_WR_OLY      0x69
#define DEV_WR_OLY_STP  0x78
#define DEV_RD_STP      0x87
#define DEV_WR_RD_STP   0x2D
#define DEV_WR_CFG      0xD2
#define DEV_RD_CFG      0xE1
#define DEV_EN_SLP      0x1E
#define DEV_RD_REV      0xC3

// finish flag
#define ERROR           0x00
#define DONE            0x01

// error definition
#define ERR_STA         0x08
#define ERR_ADR         0x02
#define ERR_CRC         0x01

// function declaration
uint64_t gx28e17_read_rom             (uint8_t spd);
uint8_t  gx28e17_match_rom            (uint8_t spd, uint64_t id);
uint8_t  gx28e17_match_rom_od         (uint8_t spd, uint64_t id);
uint8_t  gx28e17_search_rom           (uint8_t spd, uint64_t * ids);
uint8_t  gx28e17_skip_rom             (uint8_t spd);
uint8_t  gx28e17_skip_rom_od          (uint8_t spd);
uint8_t  gx28e17_resume_rom           (uint8_t spd);
uint8_t  gx28e17_write_with_stop      (uint8_t spd, uint8_t addr, uint8_t wlen, uint8_t * wdat);
uint8_t  gx28e17_write_no_stop        (uint8_t spd, uint8_t addr, uint8_t wlen, uint8_t * wdat);
uint8_t  gx28e17_write_only_no_stop   (uint8_t spd, uint8_t wlen, uint8_t * wdat);
uint8_t  gx28e17_write_only_with_stop (uint8_t spd, uint8_t wlen, uint8_t * wdat);
uint8_t  gx28e17_read_with_stop       (uint8_t spd, uint8_t addr, uint8_t rlen, uint8_t * rdat);
uint8_t  gx28e17_write_read_with_stop (uint8_t spd, uint8_t addr, uint8_t wlen, uint8_t * wdat, uint8_t rlen, uint8_t * rdat);
void     gx28e17_write_config         (uint8_t spd, uint8_t cfg);
uint8_t  gx28e17_read_config          (uint8_t spd);
void     gx28e17_enable_sleep         (uint8_t spd);
uint8_t  gx28e17_read_revision        (uint8_t spd);
uint16_t gx28e17_generate_crc         (uint8_t dcmd, uint8_t addr, uint8_t wlen, uint8_t * wdat, uint8_t rlen);






void Read_Rom(uint8_t spd);








#endif
