

/*--------------------------------------------------------------------|
|                     !!!!!!!!!! NOTE !!!!!!!!!!                      |
|                                                                     |
|  The DQ port MUST be configured as open-drain output AT ALL TIMES   |
|--------------------------------------------------------------------*/

#include "gx1833e.h"
#include "delay.h"
/*---------------------------------------------------------------------
  Function    : gx1833e_onewire_reset
  Description : initialization sequence (reset pulse + presence pulse)
  Parameter   : none
  Return      : if presence pulse is detected
---------------------------------------------------------------------*/
uint8_t gx1833e_onewire_reset (void)
{
  uint8_t rxd = 1;
  
  // transmit reset pulse
  gx1833e_gpio_pulldown();
  delay_us(GX1833e_TIME_RST);
  gx1833e_gpio_release();
  
  // detect presence pulse
  delay_us(GX1833e_TIME_MSP);
  rxd = gx1833e_gpio_sample();
  delay_us(GX1833e_TIME_RST - GX1833e_TIME_MSP);

  return ((rxd == 0) ? GX1833e_ACK : GX1833e_NACK);
}

/*---------------------------------------------------------------------
  Function    : gx1833e_onewire_read_bit
  Description : read one bit from the 1-wire bus
  Parameter   : none
  Return      : received bit
---------------------------------------------------------------------*/
uint8_t gx1833e_onewire_read_bit (void)
{
  uint8_t rxd = 0;
  
  // start read slot
	gx1833e_gpio_pulldown();	
  delay_us(GX1833e_TIME_RL);
	gx1833e_gpio_release();
  
  // sample the 1-wire bus
	delay_us(GX1833e_TIME_MSR - GX1833e_TIME_RL);
	rxd = gx1833e_gpio_sample();
  delay_us(GX1833e_TIME_SLT - GX1833e_TIME_MSR);
  
  // recovery time
  delay_us(GX1833e_TIME_REC);
  
  return rxd;
}

/*---------------------------------------------------------------------
  Function    : gx1833e_onewire_write_bit
  Description : write one bit to the 1-wire bus
  Parameter 1 : bit to be transmitted
  Return      : none
---------------------------------------------------------------------*/
void gx1833e_onewire_write_bit (uint8_t txd)
{
  if(txd == 0) {
		// start write-zero slot
    gx1833e_gpio_pulldown();
    delay_us(GX1833e_TIME_W0L);
		gx1833e_gpio_release();
	}
  else {
		// start write-one slot
    gx1833e_gpio_pulldown();
    delay_us(GX1833e_TIME_W1L);
		gx1833e_gpio_release();
    delay_us(GX1833e_TIME_SLT - GX1833e_TIME_W1L);
	}
  
  // recovery time
  delay_us(GX1833e_TIME_REC);
}

/*---------------------------------------------------------------------
  Function    : gx1833e_onewire_read_byte
  Description : read one byte from the 1-wire bus
  Parameter   : none
  Return      : received byte
---------------------------------------------------------------------*/
uint8_t gx1833e_onewire_read_byte (void)
{
  uint8_t dat = 0;
  uint8_t rxd = 0;
  uint8_t i;
  for(i = 0; i < 8; i ++) {
    dat = dat >> 1;
    rxd = gx1833e_onewire_read_bit();
    dat = dat | ((rxd == 0) ? 0x00 : 0x80);
  }
  
  return dat;
}

/*---------------------------------------------------------------------
  Function    : gx1833e_onewire_write_byte
  Description : write one byte to the 1-wire bus
  Parameter 1 : byte to be transmitted
  Return      : none
---------------------------------------------------------------------*/
void gx1833e_onewire_write_byte (uint8_t dat)
{
  uint8_t txd = 0;
  uint8_t i;
  for(i = 0; i < 8; i ++) {
    txd = dat & 0x01; // LSB first
    dat = dat >> 1;
    gx1833e_onewire_write_bit(txd);
  }
   delay_us(500);
}
