/*--------------------------------------------------------------------------------------
  Copyright (c) 2023 GXCAS, Inc. All rights reserved

  File Name   : gx1832_onewire.h
  File Type   : header file
  Author      : zhengkl
  Date        : 2023-04-11
  Version     : 0.1
  Description : implement the underlying timing of 1-wire bus

  Modification History :
  Date      By       Version    Change Description
  ====================================================================================
  23/04/11  zhengkl  0.1        Original
--------------------------------------------------------------------------------------*/

#ifndef __GX1832_ONEWIRE_HEADER_FILE
#define __GX1832_ONEWIRE_HEADER_FILE

// ACK/NACK
#define GX1832_ACK      0x01
#define GX1832_NACK     0x00

// timing definition in microseconds (us)
// 1. SLOT
#define GX1832_TIME_SLT   70
#define GX1832_TIME_REC    5
// 2. RESET & PRESENCE
#define GX1832_TIME_RST  500
#define GX1832_TIME_MSP   70
// 3. WRITE
#define GX1832_TIME_W0L   70
#define GX1832_TIME_W1L    5
// 4. READ
#define GX1832_TIME_RL     5
#define GX1832_TIME_MSR   15

// function declaration
uint8_t gx1832_onewire_reset      (void);
uint8_t gx1832_onewire_read_bit   (void);
void    gx1832_onewire_write_bit  (uint8_t txd);
uint8_t gx1832_onewire_read_byte  (void);
void    gx1832_onewire_write_byte (uint8_t dat);

#endif
