/*--------------------------------------------------------------------------------------
  Copyright (c) 2023 GXCAS, Inc. All rights reserved

  File Name   : main.c
  File Type   : source file
  Author      : zhengkl
  Date        : 2023-04-11
  Version     : 0.1
  Description : test GX1832

  Modification History :
  Date      By       Version    Change Description
  ====================================================================================
  23/04/11  zhengkl  0.1        Original
--------------------------------------------------------------------------------------*/

#include "gx1832.h"
#include "usart.h"
#include "main.h"

//---------------Main----------------//
int main(void)
{
  usart_initialize();
  
  // configure the GPIO (performed only once at power-up)
  gx1832_gpio_configure();

  // declare signed variables
  int16_t temp_hex; // temperature in signed hexadecimal
  float   temp_cel; // temperature in Celsius degree

  // declare an array of IDs
  uint8_t  num;
  uint64_t ids[MAX_NUM];

  while(1) {
    // delay 1s
    for(uint8_t i = 0; i < 20; i ++)
		  gx1832_gpio_delay(50000);
    
    // search for devices on the bus
    num = gx1832_search(ids);

    if(num == 0) {
      printf("No device on the bus.\n");
      break;
    }

    for(uint8_t i = 0; i < num; i ++) {
      // address the specified GX1833
      gx1832_match(ids[i]);

      // start temperature conversion
      gx1832_convert();

      // delay 50ms
      gx1832_gpio_delay(50000);
    }

    for(uint8_t i = 0; i < num; i ++) {
      // address the specified GX1833
      gx1832_match(ids[i]);

      // read temperature result
      temp_hex = gx1832_read_temperature();

      // calculate the temperature in Celsius degree
      temp_cel = temp_hex * 0.0625;
    
      printf("Dev[%d]=%f.\n", i, temp_cel);
    }
    
    printf("Temperature update completed.\n");
  }
}
