/*--------------------------------------------------------------------------------------
  Copyright (c) 2023 GXCAS, Inc. All rights reserved

  File Name   : gx1832_gpio.h
  File Type   : header file
  Author      : zhengkl
  Date        : 2023-04-11
  Version     : 0.1
  Description : DQ port control (based on STM32)

  Modification History :
  Date      By       Version    Change Description
  ====================================================================================
  23/04/11  zhengkl  0.1        Original
--------------------------------------------------------------------------------------*/

#ifndef __GX1832_GPIO_HEADER_FILE
#define __GX1832_GPIO_HEADER_FILE

// pin definition
#define GX1832_GPIO_CLK  RCC_APB2Periph_GPIOA
#define GX1832_GPIO_PORT GPIOA
#define GX1832_GPIO_PIN  GPIO_Pin_0

// function declaration
void    gx1832_gpio_configure (void);
void    gx1832_gpio_pulldown  (void);
void    gx1832_gpio_release   (void);
uint8_t gx1832_gpio_sample    (void);
void    gx1832_gpio_delay     (uint16_t us);

#endif
