#include <stdio.h>
#include "IIC_L.h"
#include "delay.h"
#include "usart.h"
#include "GX175.H"

#define GX175_ADDR 0X90



void GX175_Read_Temp(void)
{
    unsigned char MSB = 0X00, LSB = 0X00;
    unsigned short REG_VALUE = 0X0000;
    float Temp = 0.0;
    R_2BYTE_IIC_L(GX175_ADDR,0x00, &MSB, &LSB);
    REG_VALUE = MSB << 8 | LSB;
    if (MSB & 0X80) // ¶
    {
        REG_VALUE = ~REG_VALUE;
        REG_VALUE += 0X0001;
        Temp = REG_VALUE * 0.00390625;
        printf("GX175_TEMP:-%03.6f\r\n", Temp);
    }
    else
    {
        Temp = REG_VALUE * 0.00390625;
        printf("GX175_TEMP:%03.6f\r\n", Temp);
    }
}
unsigned char GX175_Shutdown(void)
{
    unsigned char CODE_ERR = 0x00;
    unsigned char MSB = 0X00, LSB = 0X00;
    W_BYTE_IIC_L(GX175_ADDR, 0X01, 0X01); // SDλ1
    delay_ms(10);
    R_BYTE_IIC_L(GX175_ADDR, 0X01, &MSB);
    if ((MSB & 0X01) != 0X01)
        CODE_ERR = 0x05; // SD ERR
    return CODE_ERR;
}
