
//ʱGX122
#include "gx122.h"
//ʼ״̬SOISCKCS
void FTInit() {

	GPIO_InitTypeDef  GPIO_InitStructure;
 	RCC_APB2PeriphClockCmd(SPI_CLK , ENABLE);	 //ʹPORTAʱ 
 	GPIO_InitStructure.GPIO_Pin = SOI_PIN |SCK_PIN|CS_PIN ;				//PORTA.2 
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP; 		  
 	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
 	GPIO_Init(SPI_PORT, &GPIO_InitStructure);
 	GPIO_SetBits(SPI_PORT,SOI_PIN|SCK_PIN|CS_PIN);    //1

  }

static void spiStart(){
	SCK(1);
	Delay_us(2);//2
	CS0(0);
	Delay_us(2);	
	SCK(0);
}

static void spiStop(){
	Delay_us(2);	
	SCK(1);
	Delay_us(2);	
	CS0(1);
	Delay_us(2);	
	SCK(1);	
}
static unsigned short spiReadBit(){	
	
  unsigned short so;
  SOI_IO_IN();//IOóģʽ
	
	Delay_us(2);  so = SOI_IN();
	Delay_us(2);	SCK(1); 
	Delay_us(2);
	Delay_us(2);	SCK(0);
	 
	return so;
}


static unsigned short spiReadWord() {
  int i;
  u16 so_word;
	SOI_IO_IN();//IOóģʽ
	
	so_word = 0;
	
	for(i = 15; i >=0; i--)	so_word |= (spiReadBit() << i);
	Delay_us(100);//100
//	Delay_us(150);
	return so_word;
}


static void spiWriteBit(unsigned char d){	
	
  SOI_IO_OUT();//IOóģʽ
	
	Delay_us(2);  SOI_OUT(d);
	Delay_us(2);	SCK(1); 
	Delay_us(2);	
	Delay_us(2);	SCK(0);		 
}

static void spiWriteWord(unsigned short so) {
  int i;
  SOI_IO_OUT();//IOóģʽ
	for(i = 15; i >=0; i--)	spiWriteBit((so >> i) & 1);
	SOI_OUT(1);
	Delay_us(40);//40
}
static void GX122_Mode_IPU(void)
{
 	  GPIO_InitTypeDef GPIO_InitStructure;

	  GPIO_InitStructure.GPIO_Pin = SOI_PIN;
 
	  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;	

	  GPIO_Init(SPI_PORT, &GPIO_InitStructure);
}
static void GX122_Mode_Out_PP(void)
{
 	GPIO_InitTypeDef GPIO_InitStructure;
												   
  	GPIO_InitStructure.GPIO_Pin = SOI_PIN;	

  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;   

  	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;

  	GPIO_Init(SPI_PORT, &GPIO_InitStructure);
}
//**************************************************************************GX122*************************************************//


void Write_Word(u16 data)
{
	unsigned char i;
	
    SOI_IO_OUT();//IOóģʽ
	 
	for(i = 0;i<16;i++)
	{
		SCK(0);
		Delay_us (4);
		if(data&0x8000)
			SOI_OUT(1);
		else 
			SOI_OUT(0);
		data <<= 1;
		SCK(1);		
		Delay_us (4);
	}
	Delay_us(40);	
}


u16 Read_Word()
{
	  u8 i;
	  u16 data=0;
	  SOI_IO_IN();
 
	  for(i = 0;i<16;i++)
	  {
			SCK(0);
			Delay_us (2);
			data <<= 1;
			if(SOI_IN())
				data++;
			SCK(1);	
			Delay_us (2);
	  }
		Delay_us(100);
		return data;
}


 

//**************************************************************************GX122*************************************************//
void spiReadTemp() {
 	u16 temp;
	float  temp1 = 0;	 
	u16 cfg;	
	u16 th;
	u16 tl;
 
	spiStart();	
	
	temp = spiReadWord();//¶
 
	spiWriteWord(0x8008);	cfg = spiReadWord();//üĴ
	spiWriteWord(0x8010);	tl  = spiReadWord();// low temp Threshold   ֵ
	spiWriteWord(0x8018);	th  = spiReadWord();// high temp Threshold  ֵ
 
	spiStop();
	
//	UartOutW(temp);
/**¶**/
#if 1
 
	
	if((temp&0x8000) == 0 )
	{
 
		temp = temp >> 3;
		temp1 =temp*0.0625; 
		printf("ǰ¶: %f\r\n",temp1);
	}
	else 
	{
 
    temp = ((~(temp >> 3)) & 0x0FFF) +1;
		
		temp1 = temp * 0.0625; 
		
		printf("ǰ¶: -%f\r\n",temp1);
	}

	tl = tl>>3; 
	
	th = th>>3;

///**üĴ**/
//printf("ǰüĴ: %04X \r\n",cfg);
//	
///**ֵĴ**/
//printf("ǰֵĴ: %04X \r\n",tl);
//	
///**ֵĴ**/	
//printf("ǰֵĴ: %04X \r\n",th);
//	
#endif 
}
