#include "timinput.h"  
#include "delay.h"
#include "usart.h"	 	
#include "sys.h"
//////////////////////////////////////////////////////////////////////////////////
extern u8 USART1_IDLE_STA;
extern u8 USART_RX_BUF[USART_RX_LEN];

void GX0011_Init(void)
{

	GPIO_InitTypeDef GPIO_InitStructure;
	NVIC_InitTypeDef NVIC_InitStructure;
	TIM_TimeBaseInitTypeDef  TIM_TimeBaseStructure;
	TIM_ICInitTypeDef  TIM_ICInitStructure;  
 
 	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB,ENABLE); 
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM4,ENABLE);	
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO,ENABLE);
	GPIO_PinRemapConfig(GPIO_Remap_SWJ_JTAGDisable, ENABLE); 
	
	
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_6;				 
 	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING; 		 
 	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
 	GPIO_Init(GPIOB, &GPIO_InitStructure);
	
 	TIM_TimeBaseStructure.TIM_Period = 60000-1;      //ʹùϵ
	TIM_TimeBaseStructure.TIM_Prescaler =(72-1); 	   
	TIM_TimeBaseStructure.TIM_ClockDivision = TIM_CKD_DIV1; 
	TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Up; 
	TIM_TimeBaseInit(TIM4, &TIM_TimeBaseStructure); 

    TIM_ICInitStructure.TIM_Channel = TIM_Channel_1;  
    TIM_ICInitStructure.TIM_ICPolarity = TIM_ICPolarity_Falling;	
    TIM_ICInitStructure.TIM_ICSelection = TIM_ICSelection_DirectTI;
    TIM_ICInitStructure.TIM_ICPrescaler = TIM_ICPSC_DIV1;	 
    TIM_ICInitStructure.TIM_ICFilter = 0x05;
    TIM_ICInit(TIM4, &TIM_ICInitStructure);
 						
	NVIC_InitStructure.NVIC_IRQChannel = TIM4_IRQn;  
	NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 1;
	NVIC_InitStructure.NVIC_IRQChannelSubPriority = 1;  
	NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE; 
	NVIC_Init(&NVIC_InitStructure);  
}




u8 	GX0011END=0;	  	    		    
u16  GX0011CNT=0;	//GX0011Ĵ	
u8 hightime=0;
void TIM4_IRQHandler(void)
{ 		    	 
 	if(TIM_GetITStatus(TIM4,TIM_IT_CC1)!=RESET)
	{	  
		TIM_ClearITPendingBit(TIM4,TIM_IT_CC1);	//жϱ־ 	
		GX0011CNT=GX0011CNT+1;
		hightime=0;		 		     	    					   
	}    
}


//demoʹöʱܼҲʹⲿжϼ

void GET_TEMP_GX0011(u8 Tab)
{
	u16 cnt=0;	
	u32 _time=0;

	TIM_Cmd(TIM4,ENABLE ); 	//ʹܶʱ
	TIM_ITConfig(TIM4,TIM_IT_CC1,ENABLE);
	GX0011CNT=0;
	while(1)          //ȴת
	{
			if(GX0011CNT>0) break;
			delay_us(1);	
			_time++;
			if(_time>=500000) break;	
	}
	while(1)         //ߵƽʱ50usж巢ͽ
	{
		if(RDATA)	 hightime++;	
		else hightime=0;
		if(hightime>=50) break;
		delay_us(1);	
	}	
	GX0011CNT=0;	
	hightime=0;
	while(1)          //ȴת
	{
			if(GX0011CNT>0) break;
			delay_us(1);	
			_time++;
			if(_time>=500000) break;	
	}
	while(1)         //ߵƽʱ50usж巢ͽ
	{
		if(RDATA)	 hightime++;	
		else hightime=0;
		if(hightime>=50) break;
		delay_us(1);	
	}	
		TIM_Cmd(TIM4,DISABLE ); 	//رնʱ		
		TIM_ITConfig( TIM4,TIM_IT_CC1,DISABLE);
	if(0x90==Tab)
	{
		printf("\r\n:%d\r\n",GX0011CNT); 
	    printf("\r\nTEMP:%f\r\n",GX0011CNT*0.0625-50.0625);
	}	
	delay_ms(10);
}



void GX0011_TEST_XCOM(void)  
{
	u8 CH;
	u8  temp1; 
	u16 temp2;
	u32 temp3;
		float value_AD;
  if(USART1_IDLE_STA)
   {
	   USART1_IDLE_STA=0;  
		 switch(USART_RX_BUF[0])
		 {
			 case 0x90:                 //¶ (ڵ)
			 {
			   GET_TEMP_GX0011(USART_RX_BUF[0]); 
			 }break;				 
		 }
	 }
}






